//%attributes = {"publishedSql":true}
// Method: _http_ Serve
// 2007.12.27-20:27:50 / Pasi Mankinen
// © Copyright 2007 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

C_LONGINT:C283($0; $1; _http_lSocket)
C_TEXT:C284(_http_tRequest; $_http_tRemoteIP; $_http_tRemoteIPName; _http_tUrl; _http_tFile; $_http_tHead; $_http_tSize)
C_TEXT:C284($_http_tTrace; _tcp_tRealmId; _tcp_tUrl; _http_tSendHeader)
C_LONGINT:C283($_http_lErr; $_http_lStatus; _tcp_lHitLength; $_http_lRoundTripTime; $_http_lPos)
C_LONGINT:C283($_http_lRemotePort; $_http_lLocalPort; $_http_lRemoteIP; $_http_lLocalIP; $_http_lAuthorizeAction)

//COMPILER__tcp_
//COMPILER__http_

_http_lSocket:=$1  // this is the SocketRef on which we will receive the HTTP request

//If (_tcp_ StillConnected (_http_lSocket;Current method name)=kTrue )
_http_tRequest:=""  //extracted header  `do not add to previous data
_tcp_lKeepAlive:=<>_tcp_lKeepAlive
_tcp_tKeepAliveHeader:=""
_tcp_lHitLength:=0
_http_lHitError:=0
_http_tFile:=""
_http_tHitHeader:=""
_http_tSendHeader:=""
_http_lDataSent:=0

_trace
_http_tRequest:=_tcp_ TextReceive(_http_lSocket; ksCRLF+ksCRLF; 0)
_http_tRequest:=_str AsciiBetweenDelete(_http_tRequest; 0; 8)  //v11

$_http_lPos:=Position:C15(ksCRLF+ksCRLF; _http_tRequest; *)  //v11
If ($_http_lPos>0)
	$_http_lPos:=$_http_lPos+4  //4=Length(ksCRLF +ksCRLF )
	_http_tRequestData:=Substring:C12(_http_tRequest; $_http_lPos)
	_http_tRequest:=Substring:C12(_http_tRequest; 1; $_http_lPos)
Else 
	IDLE:C311
End if 

_http_tUrl:=_http_ UrlParse(_http_tRequest)
_tcp_tHitUrl:=Substring:C12(_http_tRequest; 1; 79)

If (Position:C15(ksCRLF+ksCRLF; _http_tRequest; *)<=0)  //v11 ;* ` have we received the HTTP request header ?
	_err MESSAGE("Http request is empty, socket: "+String:C10(_http_lSocket); Current method name:C684; kFalse)
Else 
	
	_tcp_ tTcpPrsState:="authorize"
	$_http_lAuthorizeAction:=_tcp_ AuthorizeAction(_http_lSocket; _http_tUrl; _http_tRequest)
	//0 = UNAUTHORIZED_SEND
	//      <>_tcp_atpopRealmAction{1}:=_lang Current ("Reject")
	//      <>_tcp_atpopRealmAction{2}:=_lang Current ("Allow")
	//      <>_tcp_atpopRealmAction{3}:=_lang Current ("Redirect")
	//      <>_tcp_atpopRealmAction{4}:=_lang Current ("Execute")
	//      <>_tcp_atpopRealmAction{5}:=_lang Current ("Web Method")      
	Case of 
		: ($_http_lAuthorizeAction=0)  // Check http authorization
			_http_UNAUTHORIZED_SEND($1; _tcp_tRealmId; _tcp_tUrl)  //_tcp_tRealmId;_tcp_tUrl set in _tcp_ AuthorizeAction
			_http_tHitHeader:=">authenticate< "+_http_tHitHeader
		: ($_http_lAuthorizeAction=1)  // Reject        
			_http_tHitHeader:=">denied< "+_http_tHitHeader
		: ($_http_lAuthorizeAction=3)  // Redirect
			_http_REDIRECT(_tcp_tAuthorizeParameter)
		: ($_http_lAuthorizeAction=4)  // Execute
			_exe_ RUNNER(_tcp_tAuthorizeParameter)
			
			_http_SERVE_FILE_GET
			If (_http_lHitError=0)  // request not already handled ?
				_tcp_ tTcpPrsState:="doc send"
				_tcp_lHitLength:=_http_DocSend(_http_lSocket; _http_tFile; _http_tRequest)  // send the static file
			End if 
			_http_tHitHeader:=">execute done< "+_http_tHitHeader
			
		: ($_http_lAuthorizeAction=2)  // Allow
			
			_tcp_ tTcpPrsState:="http header extract"
			If (_tcp_lKeepAlive=kTrue)  // Keep-Alive support
				If (_http_HeaderExtract(_http_tRequest; "Connection"; "")="Keep-Alive@")  // do we accept keep-alive for this request ?
					_tcp_lKeepAliveCount:=_tcp_lKeepAliveCount+1
					_tcp_tKeepAliveHeader:="timeout="+String:C10(_tcp_lHitConnectTime+<>_tcp_lKeepAliveTimeout)+", max="+String:C10(<>_tcp_lMaxKeepAliveCount-_tcp_ lHitCount)  // 8/4/99-CQ
				End if 
			End if 
			_tcp_tMultipartFilename:=""  // current filename used to receive multipart requests
			
			_http_tPostData:=""
			If (_http_tRequest="POST @")
				//If (Position("POST ";_http_tRequest)>0) 
				// Wait for the end of POST data
				_http_SERVE_POST
			End if 
			
			If (_tcp_lKeepAlive=kFalse)
				If (_tcp_ BufferSize(_http_lSocket; 0)>0)  //v11: buffer 1 -> 0
					_tcp_lKeepAlive:=kTrue
					//Returns the number of bytes available in the receive buffer of a TCP socket.
					//The number of bytes received after calling ITK_TCPChRcv may be greater than the
					// value returned by ITK_TCPChRcv as some data may have been received between 
					//the two calls.    
					_err MESSAGE("Tcp receive buffer is not empty"; Current method name:C684; kFalse)
					//handle get/post ???
				End if 
			End if 
			
			$_http_tHead:=Substring:C12(_http_tRequest; 1; Position:C15(ksCRLF+ksCRLF; _http_tRequest; *)+3)  //v11 ;*
			
			_http_lDataSent:=0  //v11 _tcp_SocketDataSent (_http_lSocket)  ` data already sent in previous answers (necessary for Keep-Alive)
			If ($_http_tHead="HEAD @")
				$_http_lErr:=_http_HeaderSend(_http_lSocket; "200 OK"+ksCRLF; "text/plain"; 0)  //v11, added +ksCRLF
			Else 
				_tcp_ tTcpPrsState:="cgi"
				If (_http_Cgi(_http_lSocket; _http_tRequest; _http_tUrl)=kFalse)  // handled by some CGI style methods ?
					
					_http_SERVE_FILE_GET
					If (_http_lHitError=0)  // request not already handled ?
						_tcp_ tTcpPrsState:="doc send"
						_tcp_lHitLength:=_http_DocSend(_http_lSocket; _http_tFile; _http_tRequest)  // send the static file
					End if 
				End if   // http_procs() = false ?
			End if   //$_http_tHead="HEAD @"
		Else 
			TRACE:C157  //error
			_err MESSAGE(_lang Current("Unhandled authorize return value"); Current method name:C684; kFalse)
	End case   //authorize
	
	// Log reformating
	If (_http_lHitError=304)  // cached ?
		$_http_tSize:=" (cached)"
	Else 
		$_http_tSize:=" (size "+String:C10(_tcp_lHitLength; "|0d")+")"  // number of bytes sent in the HTTP answer
	End if 
	// If (_tcp_lKeepAlive=kTrue )
	$_http_tSize:=$_http_tSize+" *"+String:C10(_tcp_lKeepAliveCount)+"*"  // Keep-Alive counter
	// End if 
	//_http_lDataSent:=_tcp_SocketDataSent (_http_lSocket)-_http_lDataSent  ` get the real amount of data transfered for this hit
	$_http_tSize:=$_http_tSize+" - sent "+String:C10(_http_lDataSent; "|0d")
	_tcp_ SEND_SIZE_SET($_http_tSize)
	<>_tcp_lTransfered:=<>_tcp_lTransfered+_http_lDataSent
End if   // have we received the HTTP request header ?

_http_SERVER_LOG_CALL

$0:=_tcp_lKeepAlive

If (False:C215)
	// Proc: http_Server
	// This method is called by http_Slave to serve an http request
	
	// ITK Example of HTTP Server written by Ch. Quest (July 1995)
	// This example shows a basic implementation of HTTP serving HTML, GIF, JPEG,
	// QuickTime, Stuffit and Binhex documents.
	// ---------------------------------------------------
	// 14/7/95
	// first implementation
	// ------------------------
	// 26/7/95
	// added support for "If-Modified-Since:" message used by HTTP client who are
	// using a local cache (like Netscape) this reduces the amount of data transmitted
	// when the HTTP client already has the document in its cache
	// ------------------------
	// also added support for "HEAD" method which only return the header
	// ------------------------
	//April 1996 - Nick Barcet
	// Modified it for ACME Demo
	// Now reuses sockets instead of creating new processes
	//-------------------------
	//July/Aug 1996 - Nick Barcet
	//Added support for 4DPict in ACME demo
	//Added POST reception (woops...)
	//-------------------------
	//26/1/99 - Christian Quest
	//Added support for "MSIE style" POST (no CRLF at the end, use Content-Length)
	//Added Master/Slave/Closer style implementation for better performances
	//Added HTTP/1.0 Keep-Alive support to handle several request in the same socket
	//-------------------------
	//2/2/99 - Christian Quest
	//Fixed 2 bugs in receiving POST data:
	//- ITKv2 specific code was waiting for too much data to be rcvd (thanks Ed !)
	//- a problem could occur when Content-Length was not present in the header
	//-------------------------
	//27/2/99 - Christian Quest
	//- Added a check for illegal substrings in requested URLs
	//- Moved the "CGI-Like" Case Of on an separate proc (http_procs)
	//-------------------------
	//8/4/99 - Christian Quest
	//- Added new Keep-Alive timeout handler (now handled in http_master/http_slave)
	//-------------------------
	//12/5/99 - Christian Quest
	//- Added HTTP Authorizations (HTTP Realms)
	//-------------------------
	//10/6/99 - Christian Quest
	//- Added folder redirection
End if 

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 